(ns orcl.fs
  #?@(:clj
      [(:require [clojure.java.io :as io])
       (:import [java.net URI])]))

(defprotocol FileSystem
  (read-file [this file]))

#?(:clj
   (do
     (def resources-file-system
       (reify FileSystem
         (read-file [this file] (slurp (io/resource file)))))
     (defn filesystem [prefix]
       (reify FileSystem
         (read-file [this file] (slurp (io/file prefix file)))))

     (defn preread-prefix [prefix]
       (let [prefix-uri (.toURI (io/file prefix))]
         (into {}
               (for [f (file-seq (io/file prefix))
                     :when (.isFile f)
                     :let [uri (.toURI f)]]
                 [(str (.relativize prefix-uri uri)) (slurp f)]))))

     (defmacro precompile-fs [prefix]
       `(let [m# ~(preread-prefix prefix)]
          (reify FileSystem
            (read-file [this# file#] (get m# file#)))))))

(defn in-memory-file-system
  [m]
  (reify FileSystem
    (read-file [this file] (m file))))


