(ns orcl.analyzer.convert
  (:require
    #?(:clj
        [orcl.analyzer.macro :as macro]))
  #?(:cljs (:require-macros [orcl.analyzer.macro :as macro])))

(def arity-checker
  {:node   :var
   :var    "_TupleArityChecker"
   :source {:type       :site
            :source     {:type :prelude}
            :definition "_TupleArityChecker"}})

;; returns [source target-f] where
;; source expression publish some boxed values if pattern matches value
;; target-f is a function of two arguments which returns expression
;; first argument is a binding with boxed values. the second is target expression
;; return expression unboxes values, binds them to according bindings from pattern
;; and evaluates target expression in scope
(defn convert-pattern [p source]
  (let [bindings (atom [])]
    (letfn [(unravel-tuple [[[i p] & xs] focus expr]
              (if p
                (macro/with-fresh bind
                  {:node    :sequential
                   :left    {:node   :call
                             :target {:node :var :var focus}
                             :args   [{:node :const :value i}]}
                   :pattern {:type :var :var bind}
                   :right   (unravel p bind
                                     #(unravel-tuple xs focus expr))})
                (expr)))
            (unravel-record [[[field p] & xs] focus expr]
              (if p
                (macro/with-fresh bind
                  {:node    :sequential
                   :left    {:node   :field-access
                             :target {:node :var :var focus}
                             :field  field}
                   :pattern {:type :var :var bind}
                   :right   (unravel p bind
                                     #(unravel-record xs focus expr))})
                (expr)))
            (unravel [p focus expr]
              (case (:type p)
                :as (do
                      (swap! bindings conj [focus (:alias p)])
                      (unravel (:pattern p) focus expr))
                :wildcard (expr)
                :const {:node    :sequential
                        :left    {:node   :call
                                  :target {:node :var :var "Ift"}
                                  :args   [{:node   :call
                                            :target {:node :var :var "="}
                                            :args   [{:node :var :var focus}
                                                     {:node :const :value (:value p)}]}]}
                        :pattern {:type :wildcard}
                        :right   (expr)}
                :var (do (swap! bindings conj [focus (:var p)])
                         (expr))
                :tuple {:node    :sequential
                        :left    {:node   :call
                                  :target arity-checker
                                  :args   [{:node :var :var focus}
                                           {:node :const :value (count (:patterns p))}]}
                        :pattern {:type :wildcard}
                        :right   (unravel-tuple (map-indexed vector (:patterns p)) focus expr)}
                :record (unravel-record (:pairs p) focus expr)
                :call (macro/with-fresh bind
                        {:node    :sequential
                         :left    {:node   :call
                                   :target {:node :var :var (str "_Unapply" (:target p))}
                                   :args   [{:node :var :var focus}]}
                         :pattern {:type :var :var bind}
                         :right   (unravel-tuple (map-indexed vector (:args p)) bind expr)})

                :cons (macro/with-freshs 2 [head tail]
                        {:node    :sequential
                         :left    {:node   :call
                                   :target {:node :var :var "_First"}
                                   :args   [{:node :var :var focus}]}
                         :pattern {:type :var :var head}
                         :right   {:node    :sequential
                                   :left    {:node   :call
                                             :target {:node :var :var "_Rest"}
                                             :args   [{:node :var :var focus}]}
                                   :pattern {:type :var :var tail}
                                   :right   (unravel (:head p) head
                                                     #(unravel (:tail p) tail expr))}})

                :list (let [p' (reduce (fn [acc p] {:type :cons
                                                    :head p
                                                    :tail acc})
                                       {:type  :const
                                        :value ()}
                                       (reverse (:patterns p)))]
                        (unravel p' focus expr))))]
      [(unravel p source
                (fn []
                  (if (seq @bindings)
                    {:node   :tuple
                     :values (mapv (fn [[b]] {:node :var :var b}) @bindings)}
                    {:node :const :value :signal})))
       (fn [bridge target]
         (if (seq @bindings)
           (reduce (fn [target' [i [_ binding]]]
                     {:node    :sequential
                      :left    {:node   :call
                                :target {:node :var :var bridge}
                                :args   [{:node :const :value i}]}
                      :pattern {:type :var
                                :var  binding}
                      :right   target'})
                   target
                   (map-indexed vector @bindings))
           target))])))