(ns orcl.testkit.tests)

(def tests
  {:arithmetic
   [["1 + 2" 3]
    ["7 * 3" 21]
    ["30 / 6" 5]
    ["5 - 4" 1]
    ["(95 + 4 + 1) * 21" 2100]
    ["23 = 20 + 3" true]
    ["(7 >= 2 + 4)" true]
    ["15 % 4" 3]
    ["2**8" 256.0]
    ["5 / 2.0" 2.5]
    ["-(29)" -29]
    ["(+)(4,5)" 9]
    ]

   :prelude
   [["true && (true || false)" true]

    ["\"All your \" + \"base are \" + \"belong to us\""
     "All your base are belong to us"]

    ["7 = 7" true]
    ["278 /= 290" true]
    ["6 <: 10" true]
    ["23 :> 900" false]
    ["8 <= 2" false]
    ["(7 >= 2 + 4)" true]
    ["98 >= 98" true]
    ["false && true" false]
    ["false || true" true]
    ["~true" false]
    ["86 = true" false]
    ["3 :> 2" true]
    ["6 <: 7" true]

    ["(7, 3, 2)" [[7 3 2]]]
    ["[8, 9, 10]" [[8 9 10]]]
    ["if false then 7 else 8" 8]

    ["val b = true
      Ift(b) >> \"true\" | Iff(b) >> \"false\"" "true"]


    ["val n = 5
      if n :> 0 then n-1 else n+1" 4]

    ["val x = 22
      x" 22]

    ["signal" :signal],
    ["stop" []],

    ["Let(2, 3, 4) >(x,y,z)> Let(x | z)" {::one-of #{2 4}}]
    ["floor(3.2)", 3]
    ["ceil(3.2)", 4]
    ["sqrt(4)", 2.0]
    ;
    ;["abs(-4)", 4]
    ;["signum(-19) | signum(0) | signum(20)", #{-1 0 1}]
    ;["min(4,3)", 3]
    ;["max(4,3)", 4]
    ;
    ;
    ;["curry(min)(3)(2)" 2]
    ;["curry3(Let)(3)(2)(1)" [[3 2 1]]]
    ;["uncurry(curry(min))(4, 3)", 3]
    ;["flip(Let)(1,2)", [[2, 1]]]
    ;["constant(10)()", 10]
    ;["defer(Let, 10)()", 10]
    ;["defer2(Let, 10, 11)()", [[10, 11]]]
    ;["compose(lambda (x) = x + 10, lambda (x) = x + 5)(5)", 20]
    ;["while(
    ;   lambda (n) = (n <= 5),
    ;   lambda (n) = n+1
    ;  )(0)", [0 1 2 3 4 5]]
    ]

   :defs

   [["def f(a, b) = a + 2 * b
      f(1, 2)" 5]

    ["val (x,_,_) = (1,(2,2),[3,3,3])
      x" 1]

    ["def onetwosum(f) = f(1) + f(2)
      onetwosum( lambda(x) = x * 3 )" 9]

    ["def pow2(0) = 1
      def pow2(n) = 2 * pow2(n-1)

      pow2(8)" 256]

    ["def even(0) = true
      def odd(0) = false
      def even(n) = (if n :> 0 then n-1 else n+1) >i> odd(i)
      def odd(n) = (if n :> 0 then n-1 else n+1) >i> even(i)

      even(9)" false]

    ["def sumto(n) = if n <: 1 then 0 else n + sumto(n-1)
      sumto(10)" 55]

    ["def Sum(a) = ( lambda(b) = a+b )
      val f = Sum(3)
      f(4)" 7]

    ["def foo(x) =
       def bar(y) = x + y
       bar
     foo(10)(20)" 30]

    ["def Sum(Integer) :: lambda (Integer) :: Integer
      def Sum(a) = ( lambda(b) = a+b )
      val f = Sum(3)
      f(4)" 7]

    ["def foo((1, x)) = x foo((2, 1)) | foo((1,2))" 2]

    ["def tailrec(0) = 0 def tailrec(x) = tailrec(x - 1) tailrec(1)" 0]
    ]

   :comments
   [["{- I
         am
         a
         multi-line
         comment
       -}

      {- {- I am a nested comment -} -}

      -- I am a single-line comment

      1 + {- I am hidden in an expression -} 1" 2]]

   :data-structures
   [["val empty = {.  .}
      val one = {. x = 1 .}
      val two = {. y = 3, z = true .}

      empty
      | one
      | (one.x)
      | (two.y)
      | (two.z)" #{{} {"x" 1} 1 3 true}]

    ["val a = {. x = 0 .} + {.  .}
      val b = {.  .} + {. y = 1 .}
      val c = {. x = 10 .} + {. x = 2 .}
      val d = {. x = 11, y = 4 .} + {. z = 5, x = 3 .}
      val e = {. x = {. y = 12 .}, z = 13 .} + {. x = {. y = 6, z = 7 .}, y = 8, z = 9 .}

      a.x | b.y | c.x | d.x | d.y | d.z | e.x.y | e.x.z | e.y | e.z"
     #{0 1 2 3 4 5 6 7 8 9}]

    ["[1,2,3] | [1]:4:[6] | 1:5:8:[] | [] | [7]"
     #{[1 2 3] [[1] 4 6] [1 5 8] () [7]}]]

   :patterns
   [["( (1,4) | (2,5) | (1,6) )  >(1,x)> x" #{4 6}]
    ["x <(1,x)<  ( (2,5) | (1,4) | (1,6) )" {::one-of #{4 6}}]
    ["( (1,2) | (1,2,3) | (5,6) | (5,6,7) ) >(x,y)> (y,x)" #{[2 1] [6 5]}]
    ["( [1,2,3] | [4,5] | [6] | [] ) >a:b:c> (a,b,c)" #{[1 2 [3]] [4 5 ()]}]
    ["[1,2,3,4] >a:t> t >b:c:u> (u,c,b,a)" [[[4] 3 2 1]]]
    ["(-1 >-1> \"ISuccess\" ; \"Fail\")
     |(-2.3 >-2.3> \"FSuccess\" ; \"Fail\")"
     #{"ISuccess" "FSuccess"}]
    ["( (1,(2,3)) | (4,(5,6)) ) >(a,(b,c) as d)> (a,b,c,d)"
     #{[1 2 3 [2 3]]
       [4 5 6 [5 6]]}]
    ["( (1,(2,3)) | (4,true) | (5,[6,7]) | (8,signal) ) >(x,_)> x" #{1 4 5 8}]
    ["(1, [2,3], (4, 5)) > (a, b:_, (c,_)) > (a,b,c)" [[1 2 4]]]
    ["{. a = 1, b = [2,3], c = {. d =  4 .} .} > {. a = a, b = b:_, c = {. d = d .} .} > (a,b,d)" [[1 2 4]]]]

   :datatypes
   [["type Node = LeafNode(Integer) | InnerNode(Node, Node)
      def iter(LeafNode(x)) = x
      def iter(InnerNode(l, r)) = iter(l) | iter(r)
      val v = InnerNode(LeafNode(1),InnerNode(LeafNode(2),LeafNode(3)))
      iter(v)" #{1 2 3}]]

   :stop-semantic
   [["((1 | stop) | stop); 3" 1]
    ["((1 >> stop) | stop); 3" 3]
    ["(1 << stop); 3" 1]
    ["(stop << 1); 3" 3]
    ["(1 | stop) >> 2" 2]
    ["(1;signal) >> stop; 3" 3]
    ;["def f(x) = x # (f(x) <x< stop); 5" 5]
    ]

   :combinators
   [["2 | 3" #{2 3}]
    ["2 + 3 >x> x" 5]
    ["y <y< (4 | 6)" {::one-of #{4 6}}]
    ["stop ; 5 + 9" 14]
    ["(Ift(b) >> 1 | Ift(~b) >> 0) <b< true" 1]
    ["1 + ( 2 | 3 )" {::one-of #{3 4}}]

    ["def picknum() = x <x< ( 1 | 2 )
      picknum()" {::one-of #{1 2}}]

    ["def pubNums(Integer) :: Integer
      def pubNums(n) = if(n :> 0) then (n | pubNums(n-1)) else stop
      pubNums(5) >x> x" [5 4 3 2 1]]

    ["1 >> (if true then 2 else 3)" 2]]

   :blocks
   [
    ["Coeffect(1) >x> x + 2"
     [] [1 1 3]]

    ["Coeffect(4) >x>
      (val y = 3
       x + y)"
     [] [4 4 7]]

    ["Coeffect(1) >(x, y)> x + y"
     [] [1 [1 2] 3]]

    ["Coeffect(1) >x> (Coeffect(2), x) >z> z"
     [] [1 :a []] [2 :b [[:b :a]]]]

    ["val x = Coeffect(1) | Coeffect(2) x"
     [] [1 2 {:values 2 :killed-coeffects #{2}}]]

    ["val (1, y) = Coeffect(1) | Coeffect(2)
      y"
     [] [2 [2 4] []] [1 [1 3] [3]]]

    ["(val a = Coeffect(1) | Coeffect(2) a + 1 >> stop); 3" [] [1 0 {:values 3 :killed-coeffects #{2}}]]

    ["def foo(0) = 1
      def foo((1, x)) = x
      foo(Coeffect(1)) | foo(Coeffect(2)) | foo(Coeffect(3))"
     [] [1 0 1] [2 [2 2] []] [3 [1 3] 3]]
    ]

   :tailrec
   [["def tailrec(0) = 0 def tailrec(x) = tailrec(x - 1) tailrec(10000)" 0]

    ["def tailrec(0) = 0 def tailrec(x) = x - 1 >y> tailrec(y) tailrec(10000)" 0]

    ["def tailrec(0) = 0 def tailrec(x) = x - 1 >y> y >y> tailrec(y) tailrec(10000)" 0]

    ["def tailrec(0) = 0 def tailrec(x) = stop | tailrec(x - 1) tailrec(10000)" 0]

    ["def tailrec(0) = 0 def tailrec(x) = val y = x - 1 stop | tailrec(y) tailrec(10000)" 0]

    ["def f(x)=if (x<:10000) then (stop|f(x+1)) else stop\n f(0)" []]]

   :state
   [
    ["val c = Cell()
      c.read() | c.write(5) >> \"ok\"" #{5 "ok"}]

    ["val b = Channel() b.put(10) >> b.get()" 10]

    ["val r = Ref(3) r.read() >x> x | r := 5 >> r?" #{3 5}]

    ["def sort(input, comparator) =
        val b = Channel()
        val l = Ref([])
        def sort_aux(x, []) = [x]
        def sort_aux(x, y:[]) = if (comparator(x, y) <: 0) then x:[y] else y:[x]
        def sort_aux(x, y:yl) = if (comparator(x, y) <: 0) then x:y:yl else y:sort_aux(x, yl)
        def sort_Channel() :: Signal
        def sort_Channel() = (b.get() >x> (l := sort_aux(x, l?))  >> sort_Channel() >> stop); Println(\"COMPLETE\")

        # (input() >x> b.put(x)  >> stop; b.close()>>stop) | (sort_Channel() >> (Println(\"RESULT\") >> l?))


        sort(lambda()= ( (1,(2,3)) | (4,true) | (5,[6,7]) | (8,signal) ) >(x,_)> x,
             lambda(x :: Integer, y :: Integer) = x - y)" [[1 4 5 8]]]

    ]

   :types
   ^:typecheck?
   [["1 + nil" ::fail]

    ;; recursion
    ["def foo(x :: Integer) = bar(x)
      def bar(x :: Integer) = x + 1
      foo(2)" 3]

    ;; function variance
    ["def foo(f :: lambda(Integer) :: Integer) = f(1) def f(x :: Number) :: Integer = 2 foo(f)" 2]
    ["def foo(f :: lambda(Number) :: Integer) = f(1) def f(x :: Integer) :: Integer = 2 foo(f)" ::fail]

    ["def duplicate[A](x :: A) = x duplicate[Integer](1)" 1]

    ;; type alias
    ["type Foo = Integer def foo(x :: Foo) = 1 foo(1)" 1]
    ["type Foo = Integer def foo(x :: Foo) = 1 foo(nil)" ::fail]
    ["type Fn1[X] = lambda(X) :: X def apply[X](f :: Fn1[X], x :: X) :: X = f(x) apply[Integer](lambda(x :: Integer) = x + 2, 1)" 3]

    ;; tuples
    ["(1.1,1)(1) :: Integer", 1]
    ["val t = (1.1, 1)
      def nth(n :: Integer) = t(n)
      nth(1) :: Number", 1]

    ;; records
    ["def foo({. age = x .} :: {. age = Integer .}) = x + 1
      foo({. name = \"Andrew\", age = 17 .})" 18]

    ;; patterns
    ["def incFst((x, y) :: (Integer, Boolean)) = x + 1
      incFst((3, true))", 4]

    ;; type parameters inference
    ["def id[T](x :: T) :: T = x id(2)", 2]
    ["def inc(x :: Integer) = x + 1
      def double[T](f :: lambda(T) :: T, x :: T) :: T = f(f(x))
      double(inc, 2)", 4]

    ["def snd[T](t :: (Integer, T)) :: T = t(1)
      snd((1, true))", true]
    ["def snd[T](t :: (Integer, T)) :: T = t(1)
      snd((false, true))", ::fail]

    ["def snd[T]((x, y) :: (Integer, T)) :: T = y
      snd((1, true))", true]

    ["def flip[A,B,C](lambda (A, B) :: C) :: lambda(B, A) :: C
      def flip(z) = lambda(x :: B, y ::A) = z(y,x)

      def foo[A](lambda (A, A) :: A, A, A) :: A
      def foo(f, x, y) = flip(f)(x, y)
      foo(lambda(a :: Integer, b :: Integer) = a + b, 1, 2)" 3]

    ;["def snd[T]((x, y) :: (Integer, T)) :: T = y
    ;  snd((false, true))", ::fail]

    ;; lambda type inference
    ;["def foo(f :: lambda(Integer) :: Integer, x :: Integer) = f(x)
    ;  foo(lambda(x) = x + 1, 2)" 3]

    ;; stateful types
    ["def foo(r :: Ref[Number]) = r.read() >x> x | r := 5 >> r?
      foo(Ref[Number](3))" #{3 5}]
    ["def foo(r :: Ref[Top]) = r.write(1.1)
      val r = Ref[Boolean](false)
      foo(r) >> r.read() && true" ::fail]

    ["def foo(r :: Ref[Boolean]) = r.write(true)
      val r = Ref[Boolean](false)
      foo(r) >> r.read() && true" true]

    ["val ch = Channel[Integer]()
      ch.put(1) >> ch.put(2) >>
      (val x:_ = ch.getAll() x + 3)" 4]

    ;; datatypes
    ["type L[T] = Cons(T, L[T]) | Nil()
      def foo(Cons(x, _) :: L[Integer]) = x
      foo(Cons(1, Nil())) + 1" 2]

    ["type L[T] = Cons(T, L[T]) | Nil()
      def append[T](l :: L[T], x :: T) = Cons(x, l)

      def iter[T](L[T]) :: T
      def iter(Nil()) = stop

      def iter(Cons(x, xs)) = x | iter(xs)
      val l = append(append(Nil(), 1), 2)
      iter(l)", #{2 1}]
    ;; datatypes variances
    ;; TODO more realistic / complex tests
    ["type F[T] = Fun(lambda(T) :: Integer) | Nil()
      def f(x :: Number) = 1
      def app(f :: F[Integer]) = 1
      app(Fun(f))" 1]
    ["type F[T] = Fun(lambda(T) :: Integer) | Nil()
      def f(x :: Integer) = 1
      def app(f :: F[Number]) = 1
      app(Fun(f))" ::fail]

    ;; let
    ["Let() :: Signal" :signal]
    ["Let(1) :: Integer" 1]
    ["Let(1,2) :: (Integer, Integer)" [[1, 2]]]
    ]

   })
