(ns elastica.aggregation
  (:require [elastica.impl.coercion :refer [->es-value]])
  (:import  [org.elasticsearch.search.aggregations AggregationBuilders]))

(defn terms
  "https://www.elastic.co/guide/en/elasticsearch/reference/2.0/search-aggregations-bucket-terms-aggregation.html"
  [name field size]
  (doto (AggregationBuilders/terms name)
    (.field (->es-value field))
    (.size size)))
