;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   Eclipse Public License 1.0 (http://www.eclipse.org/legal/epl-v10.html)
;;   which can be found in the LICENSE file at the root of this
;;   distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns elastica.aggregation
  "Functions for the generation of aggregations that can be used with
  elastica.core/search"
  (:require [elastica.impl.coercion :refer [->es-value]]
            [utilis.logic :refer [xor]])
  (:import  [org.elasticsearch.search.aggregations AggregationBuilders]
            [org.elasticsearch.search.aggregations.metrics.avg AvgBuilder]))

(defn avg
  "https://www.elastic.co/guide/en/elasticsearch/reference/2.3/search-aggregations-metrics-avg-aggregation.html"
  [name & {:keys [field script missing]}]
  {:pre [(xor field script)]}
  (let [^AvgBuilder avg-builder (AggregationBuilders/avg name)]
    (cond-> avg-builder
      field (.field field)
      script (.script ^Script script)
      missing (.missing missing))))
