;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns fides.key
  (:require [fides.util.bytes :as bytes]
            [fides.nonce :as nonce])
  (:import javax.crypto.SecretKeyFactory
           javax.crypto.spec.PBEKeySpec
           javax.crypto.spec.SecretKeySpec))

(defonce ^:private algorithm {:factory "PBKDF2WithHmacSHA256"
                              :spec "AES"})

(defonce ^:private salt (delay (nonce/random-bytes 32)))

(defn from-bytes ^SecretKeySpec [^bytes raw-key]
  (-> (SecretKeyFactory/getInstance (:factory algorithm))
      (.generateSecret (-> raw-key
                           (bytes/to-str)
                           (char-array)
                           (PBEKeySpec. @salt 65536 256)))
      (.getEncoded)
      (SecretKeySpec. (:spec algorithm))))
