;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns fides.mac
  "message authentication code"
  (:require [fides.util.bytes :as bytes]
            [fides.key :as key])
  (:import javax.crypto.Mac))

(defonce ^:private algorithm "HmacSHA256")

(defn hash
  ([^bytes data ^bytes key]
   (hash data key nil))
  ([^bytes data ^bytes key length]
   (let [full-hash (-> (doto (Mac/getInstance algorithm)
                         (.init (key/from-bytes key)))
                       (.doFinal data))]
     (if length
       (bytes/slice full-hash 0 length)
       full-hash))))

(defn verify
  ([^bytes signature ^bytes data ^bytes key]
   (verify signature data key nil))
  ([^bytes signature ^bytes data ^bytes key length]
   (bytes/equals? signature (hash data key length))))
