;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns fides.util.keytool
  (:require [crusta.core :as sh]))

(def ^:private keytool-path "keytool")

(defn- cmd
  [& args]
  (let [args (map (fn [e] (if (keyword? e) (str "-" (name e)) e)) args)]
    (into [keytool-path] args)))

(defn exec
  [& args]
  (sh/exec (apply cmd args) :redirect-stderr true))

(defn run
  [& args]
  @(sh/run (apply cmd args) :redirect-stderr true))
