;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns fides.password
  "Password hashing with the PBKDF2 algorithm"
  (:require [crypto.password.pbkdf2 :as pbkdf2]))

(defn random-password
  ([] (random-password 32))
  ([n]
   (let [chars (concat (range 48 58) (range 65 91) (range 97 123))
         random-char #(char (nth chars (rand (count chars))))]
     (apply str (take n (repeatedly random-char))))))

(defn encrypt [raw-password]
  (pbkdf2/encrypt raw-password 347975 "HMAC-SHA256"))

(defn check [raw-password encrypted-password]
  (pbkdf2/check raw-password encrypted-password))
