;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns fides.mac
  "message authentication code"
  (:refer-clojure :exclude [hash])
  (:require [fides.util.bytes :as bytes])
  (:import javax.crypto.Mac
           javax.crypto.spec.SecretKeySpec))

(defonce ^:private algorithm "HmacSHA256")

(defn hash
  [^bytes data ^bytes key]
  (-> (doto (Mac/getInstance algorithm)
        (.init (SecretKeySpec. key algorithm)))
      (.doFinal data)))

(defn verify
  [^bytes signature ^bytes data ^bytes key]
  (bytes/equals? signature (hash data key)))
