;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(defproject com.7theta/fides "0.6.1"
  :description "A library for managing certificates and trust stores"
  :url "https://github.com/7theta/fides"
  :license {:name "MIT License"
            :url "https://opensource.org/licenses/MIT"}
  :dependencies [[org.clojure/clojure "1.11.1"]
                 [org.clojure/data.codec "0.1.1"]
                 [com.7theta/tempus "1.1.0"]
                 [com.7theta/utilis "2.4.0"]
                 [com.7theta/crusta "1.0.2"]
                 [metosin/jsonista "0.3.7"]

                 [org.bouncycastle/bcpkix-jdk18on "1.73"]]
  :jvm-opts ["--add-exports" "java.base/sun.security.x509=ALL-UNNAMED"
             "--add-exports" "java.base/sun.security.pkcs10=ALL-UNNAMED"
             "--add-exports" "java.base/sun.security.util=ALL-UNNAMED"]
  :profiles {:uberjar
             {:main fides.main
              :aot [fides.main fides.certificates]
              :uberjar-name "fides.jar"}
             :dev {:global-vars {*warn-on-reflection* true}
                   :dependencies [[org.clojure/tools.namespace "1.4.4"]]
                   :source-paths ["dev"]}}
  :clean-targets ^{:protect false} ["out" "target"]
  :prep-tasks ["compile"]
  :scm {:name "git"
        :url "https://github.com/7theta/fides"})
