(ns fides.main
  (:require [clojure.pprint]
            [fides.certificates :as certificates])
  (:gen-class))

(defn -main [& _args]
  (let [root-crt (certificates/self-signed-certificate "bouncy-root"
                                                       90
                                                       {:bc {:ca true}})
        #_#_issuing-csr (certificates/certificate-signing-request "bouncy-issuing")
        issuing-crt (certificates/fast-signed-certificate "bouncy-issuing"
                                                          90
                                                          {:bc {:ca true}}
                                                          (:certificate root-crt)
                                                          (:key root-crt))
        #_#_server-csr (certificates/certificate-signing-request "bouncy-server")
        server-crt (certificates/fast-signed-certificate "bouncy-server"
                                                         90
                                                         {:bc {:ca false} :eku [:server-auth :client-auth] :san {:dns "mercury" :ip "10.0.0.1"}}
                                                         (:certificate issuing-crt)
                                                         (:key issuing-crt))]
    (clojure.pprint/pprint {:root-crt root-crt
                            #_#_:issuing-csr issuing-csr
                            :issuing-crt issuing-crt
                            #_#_:server-csr server-csr
                            :server-crt server-crt
                            :details {:not-before (certificates/not-before (:certificate server-crt))
                                      :not-after (certificates/not-after (:certificate server-crt))
                                      :expires (certificates/expires (:certificate server-crt))
                                      :serial-number (certificates/serial-number (:certificate server-crt))
                                      :public-key (certificates/public-key (:certificate server-crt))
                                      :subject (certificates/subject (:certificate server-crt))}})))
