;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns fides.random
  (:refer-clojure :exclude [int long float double boolean bytes])
  (:import [java.security SecureRandom]))

(defonce ^:private secure-random (SecureRandom/getInstanceStrong))

(defn int [] (.nextInt ^SecureRandom secure-random))

(defn long [] (.nextLong ^SecureRandom secure-random))

(defn float [] (.nextFloat ^SecureRandom secure-random))

(defn double [] (.nextDouble ^SecureRandom secure-random))

(defn boolean [] (.nextBoolean ^SecureRandom secure-random))

(defn bytes
  [n]
  (let [ba (byte-array n)]
    (.nextBytes ^SecureRandom secure-random ba)
    ba))
