;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns fides.store
  (:require [clojure.java.io :as io])
  (:import [fides.tls Credential]
           [org.bouncycastle.jce.provider BouncyCastleProvider]
           [java.security KeyStore]
           [java.io ByteArrayOutputStream]))

(defn write
  [password & creds]
  (let [password (.toCharArray ^String password)
        ^KeyStore ks (KeyStore/getInstance
                      "pkcs12"
                      (BouncyCastleProvider.))]
    (.load ks nil password)
    (doseq [^Credential c creds]
      (if-let [key (.key c)]
        (.setKeyEntry ks
                      (str (:cn c) ".key")
                      key
                      password
                      ^"[Ljava.security.cert.Certificate;"
                      (into-array [(.cert ^Credential c)]))
        (.setCertificateEntry ks (:cn c) (.cert c))))
    (with-open [ks-f (ByteArrayOutputStream.)]
      (.store ks ks-f password)
      (.toByteArray ks-f))))
