;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns dev
  (:require [fides.tls :as tls]
            [fides.store :as p12]
            [tempus.core :as t]
            [tempus.duration :as td]))

(defn generate-dev-chain
  []
  (let [ca (tls/self-signed-ca
            {:cn "localhost-dev-ca"
             :expiry (t/+ (t/now) (td/years 5))})
        server (tls/signed-service
                {:cn "localhost-dev-server"
                 :signer ca
                 :validity (:validity ca)
                 :extensions {:san {:dns ["localhost"]
                                    :ip  ["127.0.0.1" "0.0.0.0"]}}})
        client (tls/signed-client
                {:cn "localhost-dev-client"
                 :signer ca
                 :validity (:validity ca)})]
    (doseq [[prefix cred] [["ca" ca] ["server" server] ["client" client]]]
      (let [{:keys [cert key]} (tls/->pem cred)]
        (spit (str prefix ".crt") cert)
        (spit (str prefix ".key") key)))
    (->> (p12/create "secret"
                     client
                     (-> server
                         tls/->pem
                         (dissoc :key)
                         tls/pem->))
         (p12/->bytes "secret")
         (spit "client.p12"))))




(generate-dev-chain)
