;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns fides.store
  (:import [java.security KeyStore]
           [java.io ByteArrayOutputStream]))

(defn create
  [^String password & creds]
  (let [password (.toCharArray ^String password)
        ^KeyStore ks (KeyStore/getInstance "PKCS12")]
    (.load ks nil password)
    (doseq [c creds]
      (if-let [key (:key c)]
        (.setKeyEntry ks (:cn c) key password
                      ^"[Ljava.security.cert.Certificate;"
                      (into-array [(:cert c)]))
        (.setCertificateEntry ks (:cn c) (:cert c))))
    ks))

(defn ->bytes
  [^String password ^KeyStore store]
  (with-open [ks-f (ByteArrayOutputStream.)]
    (.store store ks-f (.toCharArray ^String password))
    (.toByteArray ks-f)))
