(ns fides.ssh
  (:require [clojure.string :as st])
  (:import [java.security KeyFactory]
           [java.security.spec PKCS8EncodedKeySpec]
           [java.util Base64 Base64$Decoder]))

(defn rsa-private-key->pkcs8 ^PKCS8EncodedKeySpec
  [^String rsa-private-key]
  (-> (KeyFactory/getInstance "RSA")
      (.generatePrivate (->> rsa-private-key
                             (#(st/split % #"\n"))
                             (remove #(st/starts-with? % "-----"))
                             (st/join)
                             ^bytes (#(.getBytes ^String % "UTF-8"))
                             (.decode ^Base64$Decoder (Base64/getDecoder))
                             (PKCS8EncodedKeySpec.)))))
