;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns fides.random
  (:refer-clojure :exclude [int long float double boolean bytes])
  (:import [java.security SecureRandom]))

(defn int
  []
  (.nextInt ^SecureRandom (SecureRandom/getInstanceStrong)))

(defn long
  []
  (.nextLong ^SecureRandom (SecureRandom/getInstanceStrong)))

(defn float
  []
  (.nextFloat ^SecureRandom (SecureRandom/getInstanceStrong)))

(defn double
  []
  (.nextDouble ^SecureRandom (SecureRandom/getInstanceStrong)))

(defn boolean
  []
  (.nextBoolean ^SecureRandom (SecureRandom/getInstanceStrong)))

(defn bytes
  [n]
  (let [ba (byte-array n)]
    (.nextBytes ^SecureRandom (SecureRandom/getInstanceStrong) ba)
    ba))
