;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(defproject com.7theta/fides "1.6.4"
  :description "A library for managing certificates and trust stores"
  :url "https://github.com/7theta/fides"
  :license {:name "MIT License"
            :url "https://opensource.org/licenses/MIT"}
  :dependencies [[org.clojure/clojure "1.12.1"]
                 [com.7theta/tempus "2.5.3"]
                 [org.bouncycastle/bcpkix-jdk18on "1.81"
                  :exclusions [org.bouncycastle/bcutil-jdk18on]]
                 [org.bouncycastle/bcutil-jdk18on "1.81"
                  :exclusions [org.bouncycastle/bcprov-jdk18on]]
                 [org.bouncycastle/bcprov-jdk18on "1.81"]
                 [metosin/jsonista "0.3.13"]]
  :profiles {:repl
             {:global-vars {*warn-on-reflection* true}
              :source-paths ["dev"]}
             :uberjar
             {:global-vars {*warn-on-reflection* true}
              :source-paths ["test"]
              :dependencies [[com.github.clj-easy/graal-build-time "1.0.5"]]
              :jvm-opts ["-Dclojure.compiler.direct-linking=true"
                         "-Dclojure.spec.skip-macros=true"]
              :main fides.main
              :aot :all
              :uberjar-name "fides.jar"}}
  :scm {:name "git"
        :url "https://github.com/7theta/fides"})
