(ns fontawesome.core
  (:require [clojure.xml :as xml]
            [clojure.java.io :as io]))

(defmacro deficon
  [icon file]
  (let [svg (xml/parse (io/file (io/resource file)))
        view-box (-> svg :attrs :viewBox)
        contents (map (fn [{:keys [tag attrs]}]
                        [tag (assoc attrs :fill "currentColor")])
                      (:content svg))]
    `(defn ~icon
       [props#]
       [:svg {:class-name (get props# :class-name)
              :view-box ~view-box}
        ~@contents])))
