;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns fontawesome.core
  #?(:cljs (:require-macros [fontawesome.core]))
  (:require [helix.core]
            [helix.dom]
            #?@(:clj [[clojure.xml :as xml]
                      [clojure.java.io :as io]])))

#?(:clj
   (defmacro deficon
     [icon-name file]
     (let [props (gensym)]
       `(helix.core/defnc ~icon-name
          [~props]
          {:helix/features {:fast-refresh true}}
          ~(let [svg (xml/parse (io/file (io/resource file)))
                 view-box (-> svg :attrs :viewBox)
                 contents (map (fn [{:keys [tag attrs]}]
                                 `(helix.core/$ ~tag ~attrs))
                               (:content svg))]
             `(helix.dom/svg {:class (get ~props :class)
                              :view-box ~view-box}
                             ~@contents))))))
