(ns formal.select
  (:require [formal.input :as input]
            [malli.core :as m]
            [malli.transform :as mt]
            [reagent.core :as r]
            [react :as react]
            [utilis.fn :refer [fsafe]]
            [utilis.js :as j]))

(defn -select
  [props & children]
  (into [:f> input/-input (assoc props :component :select)]
        children))

(defn -option
  [props & children]
  (into [:option props] children))
