(ns formal.form
  (:require [formal.form.validation :refer [watcher registry-values]]
            [helix.core :refer [$ <> defnc]]
            [helix.dom :refer [div] :as dom]
            [helix.children :as hch]
            [helix.hooks :refer [use-effect]]
            [signum.signal :refer [signal alter!]]
            [react :as react]
            [utilis.js :as j]
            [utilis.fn :refer [fsafe]]))

(def FormContext (react/createContext))

(defnc form
  [props]
  (let [context (react/useContext FormContext)
        [registry _] (react/useState (signal {:inputs {}
                                              :input-key-mappings {}}))
        on-submit (when-let [on-submit (:on-submit props)]
                    (fn [event]
                      (doto event
                        (j/call :stopPropagation)
                        (j/call :preventDefault))
                      (let [{:keys [value
                                    error?
                                    has-all-inputs?]} (registry-values @registry {:subscribe-signals? false})]
                        (when (and has-all-inputs? (not error?))
                          (on-submit value)))
                      false))]
    (use-effect [on-submit] (alter! registry assoc :on-submit on-submit))
    ($ ^:native (j/get FormContext :Provider) {:value registry}
       (dom/form {& (-> props
                        (dissoc :on-value :on-error :on-incomplete :on-change)
                        (assoc :on-submit on-submit))}
                 ($ watcher
                    {& (-> props
                           (select-keys [:on-value :on-error :on-incomplete :on-change])
                           (merge {:registry registry}))})
                 (hch/children props)))))
