(ns formal.hooks
  (:require [formal.form :refer [FormContext]]
            [signum.hooks :refer [use-signal]]
            [signum.subs :refer [reg-sub subscribe]]
            [react :as react]))

(declare warn-nil-registry)

(defn use-input-value
  [input-id]
  (let [registry (react/useContext FormContext)]
    (warn-nil-registry registry)
    (use-signal (subscribe [:formal.hooks/input-value registry input-id]))))

(reg-sub
 :formal.hooks/input-value
 (fn [[_ registry input-id]]
   (let [registry @registry]
     (when-let [input (get-in registry [:inputs input-id])]
       (:value @input)))))

;;; Private

(defn- warn-nil-registry
  [registry]
  (when (not registry)
    (js/console.warn "Using formal.hooks/use-input-value outside of a formal.form/FormContext. You must use formal hooks inside of formal.form/form component.")))
