;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns fs-watch.watcher
  (:require
   [fs-watch.core :refer [stop watch]]
   [integrant.core :as ig]))

(defmethod ig/init-key :fs-watch/watcher
  [_ {:keys [callback-fn paths]}]
  (watch callback-fn paths))

(defmethod ig/halt-key! :fs-watch/watcher
  [_ watcher]
  (stop watcher))
