;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns qr-clj.core
  (:require [utilis.fs :refer [ensure-temp-dir]])
  (:import [com.google.zxing BarcodeFormat]
           [com.google.zxing.qrcode QRCodeWriter]
           [com.google.zxing.client.j2se MatrixToImageWriter]))

(defn encode
  [^bytes b w h]
  (ensure-temp-dir
   (let [os (java.io.ByteArrayOutputStream.)]
     (-> (QRCodeWriter.)
         (.encode (apply str (map #(char (bit-and % 255)) b))
                  BarcodeFormat/QR_CODE w h)
         (MatrixToImageWriter/writeToStream "png" os))
     (.toByteArray os))))
