;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(defproject com.7theta/qr-clj "0.4.8"
  :url "https://github.com/7theta/qr-clj"
  :license {:name "MIT License"
            :url "https://opensource.org/licenses/MIT"}
  :dependencies [[org.clojure/clojure "1.12.1"]
                 [com.7theta/utilis "3.5.0"]
                 [com.google.zxing/javase "3.5.3"]
                 [com.github.auties00/qr-terminal "2.2"]]
  :profiles {:repl
             {:global-vars {*warn-on-reflection* true}}
             :uberjar
             {:global-vars {*warn-on-reflection* true}
              :source-paths ["test"]
              :dependencies [[com.github.clj-easy/graal-build-time "1.0.5"]]
              :jvm-opts ["-Dclojure.compiler.direct-linking=true"
                         "-Dclojure.spec.skip-macros=true"]
              :main qr-clj.main
              :aot :all
              :uberjar-name "qr-clj.jar"}}
  :scm {:name "git"
        :url "https://github.com/7theta/qr-clj"})
