(ns schema.util.parse
  (:require [clojure.walk :refer [postwalk]]))

(defn parse-meta
  [args]
  (let [meta-map (if (string? (first args)) {:doc (first args)} {})
        args (if (string? (first args)) (next args) args)

        meta-map (if (map? (first args)) (conj meta-map (first args)) meta-map)
        args (if (map? (first args)) (next args) args)

        params (first args)
        meta-map (assoc meta-map :arglists `(quote [~params]))]
    {:meta-map meta-map
     :params args}))

(defn parse-args
  [args]
  (let [params (first args)
        args (next args)
        [ins _ [outs]] (->> args
                            first
                            (postwalk (fn [x] (if (= '_ x) 'any? x)))
                            (partition-by (partial = '=>)))
        body (next args)]
    {:in-schema (vec ins)
     :out-schema outs
     :params params
     :body body}))
