(ns servo-rn.reserved
  (:require [clojure.string :as st]
            [clojure.set :refer [map-invert]]))

(declare reserved-word->col
         col->reserved-word)

(defn ->sql
  [col]
  (get reserved-word->col (name col) col))

(defn sql->
  [col]
  (get col->reserved-word (name col) col))

;;; Private

(def reserved-words
  (mapv st/lower-case
        ["ABORT"
         "ACTION"
         "ADD"
         "AFTER"
         "ALL"
         "ALTER"
         "ALWAYS"
         "ANALYZE"
         "AND"
         "AS"
         "ASC"
         "ATTACH"
         "AUTOINCREMENT"
         "BEFORE"
         "BEGIN"
         "BETWEEN"
         "BY"
         "CASCADE"
         "CASE"
         "CAST"
         "CHECK"
         "COLLATE"
         "COLUMN"
         "COMMIT"
         "CONFLICT"
         "CONSTRAINT"
         "CREATE"
         "CROSS"
         "CURRENT"
         "CURRENT_DATE"
         "CURRENT_TIME"
         "CURRENT_TIMESTAMP"
         "DATABASE"
         "DEFAULT"
         "DEFERRABLE"
         "DEFERRED"
         "DELETE"
         "DESC"
         "DETACH"
         "DISTINCT"
         "DO"
         "DROP"
         "EACH"
         "ELSE"
         "END"
         "ESCAPE"
         "EXCEPT"
         "EXCLUDE"
         "EXCLUSIVE"
         "EXISTS"
         "EXPLAIN"
         "FAIL"
         "FILTER"
         "FIRST"
         "FOLLOWING"
         "FOR"
         "FOREIGN"
         "FROM"
         "FULL"
         "GENERATED"
         "GLOB"
         "GROUP"
         "GROUPS"
         "HAVING"
         "IF"
         "IGNORE"
         "IMMEDIATE"
         "IN"
         "INDEX"
         "INDEXED"
         "INITIALLY"
         "INNER"
         "INSERT"
         "INSTEAD"
         "INTERSECT"
         "INTO"
         "IS"
         "ISNULL"
         "JOIN"
         "KEY"
         "LAST"
         "LEFT"
         "LIKE"
         "LIMIT"
         "MATCH"
         "MATERIALIZED"
         "NATURAL"
         "NO"
         "NOT"
         "NOTHING"
         "NOTNULL"
         "NULL"
         "NULLS"
         "OF"
         "OFFSET"
         "ON"
         "OR"
         "ORDER"
         "OTHERS"
         "OUTER"
         "OVER"
         "PARTITION"
         "PLAN"
         "PRAGMA"
         "PRECEDING"
         "PRIMARY"
         "QUERY"
         "RAISE"
         "RANGE"
         "RECURSIVE"
         "REFERENCES"
         "REGEXP"
         "REINDEX"
         "RELEASE"
         "RENAME"
         "REPLACE"
         "RESTRICT"
         "RETURNING"
         "RIGHT"
         "ROLLBACK"
         "ROW"
         "ROWS"
         "SAVEPOINT"
         "SELECT"
         "SET"
         "TABLE"
         "TEMP"
         "TEMPORARY"
         "THEN"
         "TIES"
         "TO"
         "TRANSACTION"
         "TRIGGER"
         "UNBOUNDED"
         "UNION"
         "UNIQUE"]))

(def reserved-word->col
  (->> reserved-words
       (map (fn [word]
              [word (str "reserved__" word)]))
       (into {})))

(def col->reserved-word
  (map-invert reserved-word->col))
