;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns servo-rn.core
  (:require [servo-rn.connection :as c]
            [servo-rn.subs :as s]
            [integrant.core :as ig]))

;;; Integrant

(defmethod ig/init-key :servo-rn/connection
  [_ {:keys [db-name
             db-version
             db-display-name
             db-max-size-bytes
             on-ready on-error
             tables indices]
      :as options}]
  (let [connection (c/connect options)]
    (reset! s/db-connection connection)
    connection))

(defmethod ig/halt-key! :servo-rn/connection
  [_ connection]
  (c/disconnect connection))


;;; Connection

(def connect c/connect)
(def disconnect c/disconnect)
(def run c/run)
(def subscribe c/subscribe)
(def dispose c/dispose)
