;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns servo-rn.subs
  (:require [servo-rn.connection :as db]
            [signum.subs :refer [reg-sub]]))

(def db-connection (atom nil))

(reg-sub
 :servo/subscribe
 (fn [[_ query]]
   (when-let [connection @db-connection]
     (db/subscribe connection query)))
 (fn [value-signal _query]
   (when-let [connection @db-connection]
     (db/dispose connection value-signal)))
 (fn [value-signal _query]
   (if (instance? js/Error value-signal)
     value-signal
     @value-signal)))
