(ns servo-rn.util.query)

(defn query->table
  [query]
  (when (= :table (ffirst query))
    (second (first query))))

(defn op?
  [query ops]
  (->> query
       (some (comp (if (coll? ops)
                  (set ops)
                  #{ops})
                first))
       boolean))

(defn mutate?
  [query]
  (op? query #{:insert :update :delete}))

(defn count?
  [query]
  (op? query #{:count}))

(defn ids
  [query]
  (->> query
       (reduce (fn [ids clause]
                 (case (first clause)
                   :insert (let [[_ doc-or-docs] clause]
                             (->> (if (map? doc-or-docs)
                                    [doc-or-docs]
                                    doc-or-docs)
                                  (map :id)
                                  (concat ids)))
                   :update (let [[_ doc] clause]
                             (conj ids (:id doc)))
                   :get-all (let [[_ doc-ids] clause]
                              (concat ids doc-ids))
                   :get (let [[_ doc-id] clause]
                          (conj ids doc-id))
                   ids))
               [])
       set
       not-empty))
