;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(defproject com.7theta/servo "5.1.5"
  :description "A rehinkdb client library designed to integrate with signum"
  :url "https://github.com/7theta/servo"
  :license {:name "MIT License"
            :url "https://opensource.org/licenses/MIT"}
  :dependencies [[com.7theta/fluxus "1.0.3"]
                 [com.7theta/signum "10.0.3"]
                 [com.7theta/tempus "2.2.2"]
                 [com.7theta/vectio "2.6.5"]

                 [metosin/jsonista "0.3.8"]
                 [com.7theta/spectator "0.6.3"]

                 [integrant "0.8.1"]]
  :jvm-opts ["--enable-preview"]
  :profiles {:dev {:global-vars {*warn-on-reflection* true}
                   :dependencies [[org.clojure/clojure "1.11.1"]
                                  [org.clojure/tools.namespace "1.4.4"]
                                  [integrant/repl "0.3.3"]]
                   :source-paths ["dev"]}}
  :clean-targets ^{:protect false} ["out" "target"]
  :prep-tasks ["compile"]
  :scm {:name "git"
        :url "https://github.com/7theta/servo"})
