;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(defproject com.7theta/servo "6.0.0"
  :description "A rehinkdb client library designed to integrate with signum"
  :url "https://github.com/7theta/servo"
  :license {:name "MIT License"
            :url "https://opensource.org/licenses/MIT"}
  :dependencies [[com.7theta/vectio "3.0.0"
                  :exclusions [com.7theta/fides
                               org.eclipse.jetty/jetty-server
                               org.eclipse.jetty.http2/jetty-http2-server
                               org.eclipse.jetty.http3/jetty-http3-server
                               org.eclipse.jetty/jetty-alpn-server
                               org.eclipse.jetty/jetty-alpn-java-server
                               org.eclipse.jetty.websocket/jetty-websocket-jetty-api
                               org.eclipse.jetty.websocket/jetty-websocket-jetty-server]]
                 [com.7theta/signum "11.0.0"]
                 [com.7theta/tempus "2.5.0"]

                 [metosin/jsonista "0.3.13"]
                 [com.7theta/spectator "0.7.0"]

                 [integrant "0.13.1" :exclusions [org.clojure/clojure]]]
  :profiles {:dev {:global-vars {*warn-on-reflection* true}
                   :source-paths ["dev"]
                   :dependencies [[org.clojure/clojure "1.12.0"]
                                  [org.clojure/tools.namespace "1.5.0"]
                                  [integrant/repl "0.4.0"]]}}
  :clean-targets ^{:protect false} ["out" "target"]
  :scm {:name "git"
        :url "https://github.com/7theta/servo"})
