;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(defproject com.7theta/spectator-slf4j "0.1.4"
  :description "A library to enable observability in applications"
  :url "https://github.com/7theta/spectator"
  :license {:name "MIT License"
            :url "https://opensource.org/licenses/MIT"}
  :dependencies [[org.clojure/clojure "1.12.1"]
                 [com.7theta/spectator "0.8.0"]
                 [org.slf4j/slf4j-api "2.0.17"]]
  :aot [spectator-slf4j.adapter
        spectator-slf4j.factory
        spectator-slf4j.service-provider]
  :global-vars {*warn-on-reflection* true}
  :profiles {:repl
             {:source-paths ["dev"]}
             :uberjar
             {:dependencies [[com.github.clj-easy/graal-build-time "1.0.5"]]
              :source-paths ["test"]
              :jvm-opts ["-Dclojure.compiler.direct-linking=true"
                         "-Dclojure.spec.skip-macros=true"]
              :main spectator-slf4j.main
              :aot :all
              :uberjar-name "spectator-slf4j.jar"}}
  :scm {:name "git"
        :url "https://github.com/7theta/spectator"})
