(ns spectator.util.exception
  (:require [utilis.js :as j]))

(defn parse
  [error]
  {:error (merge
           {:type (j/get error :name)
            :message (j/get error :message)
            :file (j/get error :fileName)
            :line (j/get error :lineNumber)
            :stack (j/get error :stack)}
           (when (instance? cljs.core.ExceptionInfo error)
             {:data (ex-data error)}))})
