(ns structor.clj-kondo
  (:require [utilis.fs :refer [mkdir]]
            [structor.sh :as sh]
            [integrant.core :as ig]))

(defmethod ig/init-key :structor.clj-kondo/init [_ _]
  (mkdir ".clj-kondo" :recursive true)
  (binding [sh/*trace* false]
    (let [classpath (sh/run "lein with-profile repl classpath")]
      (sh/run ["clj-kondo --lint " classpath " --dependencies --parallel --copy-configs"]))))
