(ns structor.sh
  (:require [crusta.core :as sh]))

(def ^:dynamic *trace* false)
(defn run
  [& args]
  (let [line #(println (apply str (repeat 80 "=")))]
    (try
      (when *trace*
        (line)
        (println ">" (pr-str args)))
      (let [result @(apply sh/run (concat args [:redirect-stderr true]))]
        (when *trace*
          (println "<" result))
        result)
      (catch Exception e
        (when (instance? clojure.lang.ExceptionInfo e)
          (println ":structor/run failed" (ex-message e) (pr-str (ex-data e))))
        (throw e))
      (finally
        (when *trace* (line))))))



