;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns structor.builder
  (:refer-clojure :exclude [read-string])
  (:require [structor.npm :as npm]
            [structor.index-html :as index-html]
            [structor.shadow :as shadow]
            [structor.tailwind :as tailwind]
            [structor.android :as android]
            [structor.ios :as ios]
            [structor.jar :as jar]
            [structor.docker :as docker]
            [structor.electron :as electron]
            [structor.clj-kondo :as clj-kondo]
            [structor.task :refer [deftask]]
            [structor.available :refer [rn? electron?]]
            #?@(:bb []
                :clj [[integrant.core :as ig]])))

(deftask clean-web
  []
  {:depends [index-html/clean docker/clean electron/clean]})

(deftask clean-rn
  []
  {:depends [android/clean
             ios/clean]})

(deftask clean
  []
  {:depends [shadow/clean tailwind/clean
             (if (rn?) (clean-rn) (clean-web))]})

(deftask distclean
  []
  {:depends [clean npm/clean]})

(deftask release-web
  []
  {:depends [index-html/generate
             shadow/release
             tailwind/release
             jar/uberjar
             docker/image
             (when (electron?) (electron/release))]})

(deftask release-rn
  []
  {:depends [shadow/release
             android/release]})

(deftask release
  []
  {:depends [clean npm/install
             (if (rn?) (release-rn) (release-web))]})

(declare watch stop clean)

#?(:bb nil
   :clj
   (defmethod ig/init-key :structor.builder/watcher [_ {:keys [hooks] :as opts}]
     (watch opts)))

#?(:bb nil
   :clj
   (defmethod ig/halt-key! :structor.builder/watcher [_ watchers]
     (stop watchers)))

#?(:bb nil
   :clj
   (deftask watch
     [{:keys [hooks] :as opts}]
     {:depends [clean npm/install clj-kondo/init]}
     {:index-html (when-not (rn?) (let [w (index-html/watch)] (fn [] (index-html/stop w))))
      :tailwind (when-not (rn?)
                  (let [w (tailwind/watch)] (fn [] (tailwind/stop w))))
      :shadow (let [w (shadow/watch)] (fn [] (shadow/stop w)))}))

#?(:bb nil
   :clj
   (deftask stop
     [{:keys [index-html shadow tailwind]}]
     (when shadow (shadow))
     (when tailwind (tailwind))
     (when index-html (index-html))
     nil))
