;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns structor.npm
  (:require [structor.task :refer [deftask log]]
            [babashka.fs :as fs :refer [delete-tree]]
            [babashka.process :refer [shell]]))

(deftask clean
  []
  (delete-tree "node_modules"))

(deftask install
  []
  {:inputs []
   :outputs ["node_modules"]
   :no-op-msg "node_modules already exists"}
  (shell "npm install"))
