;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns structor.shadow
  (:require [structor.npm :as npm]
            [structor.available :refer [rn?]]
            [structor.task :refer [deftask log]]
            #?@(:bb []
                :clj [[shadow.cljs.devtools.server :as server]
                      [shadow.cljs.devtools.api :as shadow]])
            [babashka.fs :as fs]
            #?(:bb [babashka.process :refer [shell]])))

(defonce output-file "resources/public/js/compiled/main.js")

(deftask clean
  []
  (doseq [path ["target" ".shadow-cljs" "resources/public/js/compiled"
                (when (rn?) "app")]]
    (fs/delete-tree path)))

(deftask release
  [{:keys [build-id build-config]
    :or {build-id :prod}}]
  {:depends [npm/install npm/outdated clean]
   :inputs (concat
            (fs/glob "src" "**.clj*")
            (fs/glob "prod" "**.clj*")
            ["project.clj" "node_modules"])
   :outputs [output-file]}
  #?(:bb
     (shell "npx shadow-cljs release" (name build-id))
     :clj
     (if build-config
       (shadow/with-runtime
         (shadow/release* build-config {}))
       (shadow/release build-id))))

#?(:bb nil
   :clj
   (deftask watch
     [{:keys [build-id build-config]
       :or {build-id :dev}}]
     {:depends [npm/install npm/outdated]}
     (server/start!)
     (if build-config
       (shadow/watch* build-config {})
       (shadow/watch build-id))))

#?(:bb nil
   :clj
   (deftask stop
     [_watcher]
     (server/stop!)))
