;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns structor.index-html
  (:require [structor.artifact :as artifact]
            [structor.task :refer [deftask]]
            [structor.fs :refer [ensure-paths absolute-path]]
            #?@(:bb []
                :clj [[fs-watch.core :as fs-watch]])
            [babashka.fs :as fs]
            [clojure.string :as st]))

(def input-file "dev-resources/templates/index.html")
(def output-file "resources/public/index.html")

(deftask clean
  []
  (fs/delete-if-exists output-file))

(deftask generate
  []
  {:inputs [input-file]
   :outputs [output-file]}
  (ensure-paths [input-file output-file])
  (-> (slurp input-file)
      (st/replace #"APP_NAME" artifact/name)
      (st/replace #"APP_VERSION" artifact/version)
      (->> (spit output-file))))

#?(:bb nil
   :clj
   (deftask watch
     []
     {:depends [generate]}
     (fs-watch/watch (fn [_changes] (generate)) [(absolute-path input-file)])))

#?(:bb nil
   :clj
   (deftask stop
     [watcher]
     (when watcher (fs-watch/stop watcher))))
