;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns structor.docker
  (:require [structor.task :refer [deftask log]]
            [structor.artifact :as artifact]
            [babashka.process :refer [shell]]
            [babashka.fs :as fs]
            [clojure.string :as st]))

(def image-dir "build/images")
(def image-export (str image-dir "/" artifact/docker-image-export))

(deftask clean
  []
  (fs/delete-tree image-export)
  (try
    (when (->> (shell {:out :string :err :string} "docker images") :out
               (re-find (re-pattern (st/replace artifact/docker-image #":" ".*"))))
      (shell "docker rmi" artifact/docker-image))
    (catch Exception e
      (if (re-find #"Cannot connect to the Docker daemon at unix:///var/run/docker.sock"
                   (ex-message e))
        (log :error "Cannot connect to the docker daemon")
        (throw e)))))

(deftask image
  []
  (fs/create-dirs image-dir)
  (shell "docker build -t" artifact/docker-image ".")
  (shell "sh -c" (str "docker save " artifact/docker-image " | gzip > " image-export)))
