;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns structor.jar
  (:require [structor.artifact :as artifact]
            [structor.task :refer [deftask]]
            [babashka.process :refer [shell]]
            [babashka.fs :refer [glob delete-tree]]))

(def output-file (str "target/" artifact/uberjar))

(deftask clean
  []
  (delete-tree output-file))

(declare outdated)

(deftask outdated
  []
  (shell {:continue true} "lein ancient :check-clojure"))

(deftask uberjar
  []
  {:inputs (concat
            ["project.clj"]
            (glob "resources" "**")
            (glob "src" "**/*.clj")
            (glob "src" "**/*.cljc")
            (glob "prod" "**/*.clj")
            (glob "prod" "**/*.cljc"))
   :outputs [output-file]}
  (outdated)
  (shell "lein uberjar"))
