(ns structor.unused
  (:require [utilis.fs :as fs]
            [utilis.map :refer [map-vals]]
            [clojure.edn :as edn]
            [jsonista.core :as json]
            [clojure.string :as st]))

(defn lein-get-key
  [key]
  (->> (edn/read-string (slurp "project.clj"))
       (partition-all 2 1)
       (map (fn [[k v]] (when (= key k) v)))
       (remove nil?)
       first))

(defn lein-deps
  []
  (let [parse-deps (fn [deps]
                     (->> deps (map (comp name first)) set))
        profiles (lein-get-key :profiles)]
    {:deps (parse-deps (lein-get-key :dependencies))
     :prod-deps (->> (concat (get-in profiles [:uberjar :dependencies]))
                     (concat (get-in profiles [:prod :dependencies]))
                     parse-deps)
     :dev-deps (parse-deps (get-in profiles [:repl :dependencies]))}))

(defn npm-deps
  []
  (when (fs/file? "package.json")
    (let [p (json/read-value (slurp "package.json"))]
      {:deps (-> (get p "dependencies") keys set)
       :dev-deps (-> (get p "devDependencies") keys set)})))

(defn deps
  []
  (merge-with (comp set concat) (lein-deps) (npm-deps)))


(deps)

(defn requires
  []
  (let [ls (fn [dir]
             (->> (fs/ls dir :recursive true)
                  (filter (comp (partial re-find #".*\.cljs?$") str))))
        profiles (lein-get-key :profiles)
        requires (fn [file]
                   (->> (edn/read-string (slurp file))
                        (filter (fn [form]
                                  (and (sequential? form) (= :require (first form)))))
                        (mapcat (fn [requires]
                                  (->> (rest requires)
                                       (map #(first (st/split (name (first %)) #"\.")))
                                       (remove empty?)
                                       set)))))]
    {:requires (->> ["src"]
                    (concat (lein-get-key :source-paths))
                    (mapcat ls)
                    (mapcat requires)
                    set)
     :prod-requires (->> (concat (get-in profiles [:uberjar :source-paths]))
                         (concat (get-in profiles [:prod :source-paths]))
                         (mapcat ls)
                         (mapcat requires)
                         set)
     :dev-requires (->> (get-in profiles [:repl :source-paths])
                        (mapcat ls)
                        (mapcat requires)
                        set)}))

(deps)
(requires)
