;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns structor.fs
  (:require [structor.task :refer [deftask]]
            [babashka.fs :as fs]
            [clojure.string :as st]))

(declare path-dir)

(deftask ensure-paths
  [paths]
  {:outputs (map path-dir paths)
   :no-op-msg "output dirs exist"}
  (doseq [path (map path-dir paths)]
    (fs/create-dirs path)))

(defn absolute-path
  [path]
  (cond-> path
    (fs/relative? path) ((comp str fs/absolutize))))

;;; Private

(defn path-dir
  [path]
  (->> (st/split path (re-pattern fs/file-separator))
       drop-last
       (st/join fs/file-separator)))
