;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns structor.available
  (:require [babashka.fs :refer [exists? directory?]])
  (:import [java.net URL]))

(defn npm?
  []
  (try
    (let [url (URL. "http://npmjs.org")
          connection (doto (.openConnection url)
                       (.connect))]
      (-> connection (.getInputStream) (.close))
      true)
    (catch Exception _ false)))

(defn rn?
  ([] (rn? "shadow-cljs.edn"))
  ([shadow-cljs-edn]
   (boolean
    (when (exists? shadow-cljs-edn)
      (when-let [edn (not-empty (slurp shadow-cljs-edn))]
        (let [{:keys [builds]} (read-string edn)]
          (some (fn [[_ {:keys [target]}]]
                  (= target :react-native))
                builds)))))))
