;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns structor.artifact
  (:refer-clojure :exclude [name])
  (:require [clojure.string :as st]))

(let [[_ pn v] (->> (slurp "project.clj")
                    (re-find #"defproject (.*) \"(.*)\""))
      [g n] (st/split pn #"/")]
  (def group (when (and g n) g))
  (def name (if (and g n) n g))
  (def version v))

(def jar (str name "-" version ".jar"))
(def uberjar (or (last (re-find #"\:uberjar-name\s+\"(.*)\"" (slurp "project.clj")))
                 (str name ".jar")))

(def docker-image
  (str (when (and group name)
         (str group "/"))
       name ":" version))
