;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns structor.ios
  (:require [structor-task.core :refer [deftask]]
            [babashka.process :refer [shell]]
            [babashka.fs :as fs]))

(deftask run
  []
  (shell "npx react-native run-ios"))

(deftask clean
  []
  (fs/delete-tree "app")
  (fs/create-dir "app"))
