;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns structor.cli
  #?(:bb
     (:require [babashka.cli :as cli]
               [babashka.process :refer [shell]]
               [clojure.string :refer [trim]])))

(def args nil)

#?(:bb
   (defn init
     []
     (let [cli-spec {:os {:ref "[os]"
                          :coerce :string
                          :default "linux"}
                     :arch {:ref "[arch]"
                            :coerce :string}}]
       (alter-var-root #'args (constantly (->> (cli/parse-opts *command-line-args* {:spec cli-spec})
                                               (into {})))))))
